#pragma GCC optimize("O3")
#pragma GCC target("avx2")
#include <cstdio>
#include <algorithm>
#include <random>
#include <vector>

std::mt19937 rng;

const int N = 32005;
int n, a[N], cnt[N], b[N];

void add(int i, int d) {
	while (i < n) {
		b[i] += d;
		i |= i + 1;
	}
}

int get(int i) {
	int s = 0;
	while (i >= 0) {
		s += b[i];
		i = (i & i + 1) - 1;
	}
	return s;
}

int calc(int l, int r) {
	int ans = 0;
	for (int i = l; i <= r; ++i) {
		int down = get(a[i] - 1);
		ans += down;
		ans -= i - l - down - cnt[a[i]];
		add(a[i], 1);
		++cnt[a[i]];
	}
	for (int i = l; i <= r; ++i) {
		add(a[i], -1);
		--cnt[a[i]];
	}
	return ans;
}

std::vector<std::pair<int, int> > ans;

void apply(int l, int r) {
	std::reverse(a + l, a + r + 1);
	ans.push_back(std::make_pair(l, r));
}

int main() {
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) scanf("%d", a + i);
	for (int it = 0; it < 100; ++it) {
		int l = rng() % n, r = rng() % n;
		if (l > r) std::swap(l, r);
		int val = -calc(l, r);
		if (val > (r - l + 1) * 4) apply(l, r);
	}
	int inv = 0;
	for (int i = 0; i < n; ++i) for (int j = i + 1; j < n; ++j) inv += a[i] > a[j];
	printf("%d\n", (int)ans.size() + inv);
	for (int i = 0; i < (int)ans.size(); ++i) printf("%d %d\n", ans[i].first + 1, ans[i].second + 1);
	for (int i = 1; i < n; ++i) {
		for (int j = i; j && a[j] < a[j - 1]; --j) {
			printf("%d %d\n", j, j + 1);
			std::swap(a[j], a[j - 1]);
		}
	}
	return 0;
}